# Decision making Procedure (Algorithm 2)
# Make use of PDA (Stat_pat4) and SDA (Stat_pat3) data to create reference vectors of each respondent group 

Ref_creat1<-function(Y,Z)
{ 
  A = dim(Y)
  d1 = A[1]
  d2 = A[2]
  L1 = 0.85
  L2 = 0.15
  cnt = 0
  tnc = 0
  K = 1
  N = 1
  Ref1 = matrix(data = 0, nrow = 1, ncol = d2)
  Ref2 = matrix(data = 0, nrow = 1, ncol = d2)
  Ref3 = matrix(data = 0, nrow = 1, ncol = d2)
  Loc = matrix(data = 0, nrow = 1, ncol = d2)
  Cal = matrix(data = 0, nrow = 1, ncol = d2)
  while(cnt==0)
  {
    for(i in 1:d2)
    {
      if(Y[i]>0)
      {
        if(Y[i]>=L1)
        {
          Ref1[i] = 1
          Ref3[i] = 1
          Ref2[i] = 1
          cnt = cnt+1
          Loc[K] = i
          K = K+1
        }
        else
        {
          if(Y[i]>=L2)
          {
            Ref1[i] = Y[i]
            Ref3[i] = Y[i]
            Cal[N]=i
            N = N+1
          }
          else
          {
            Ref1[i] = 0
            Ref3[i] = 0
            Ref2[i] = 1
            cnt = cnt+1
            Loc[K] = i
            K = K+1
          }
        }
      }
      else
      {
        if(abs(Y[i])>=L1)
        {
          Ref1[i] = -1
          Ref3[i] = -1
          Ref2[i] = 1
          cnt = cnt+1
          Loc[K] = i
          K = K+1
        }
        else
        {
          if(abs(Y[i])>=L2)
          {
            Ref1[i] = Y[i]
            Ref3[i] = Y[i]
            Cal[N]=i
            N = N+1
          }
          else
          {
            Ref1[i] = 0
            Ref3[i] = 0
            Ref2[i] = 1
            cnt = cnt+1
            Loc[K] = i
            K = K+1
          }
        }
      }
    }
    L1 = L1-0.05
    L2 = L2+0.05
    K = 1
    N = 1
  }
  L11 = 0.75
  L21 = 0.25
  L30 = 0.50
  while(cnt<=(d2-1))
  { 
    tnc = (d2-cnt)
    b = matrix(data=0,nrow=cnt,ncol=tnc)
    tem = matrix(data=0,nrow=1,ncol=tnc)
    for(i in 1:cnt)
    {
      r = Loc[i]
      if(Ref1[r]== 1)
      {
        p = (r*3) 
      }
      else
      {
        if(Ref1[r]== 0)
        {
          p = (r*3)-1
        }
        else
        {
          p = (r*3)-2
        }
      }
      for(j in 1:tnc)
      {
        q = Cal[j]
        b[i,j]= Z[p,q]
        tem[j] = tem[j]+b[i,j]
      }
    }
    C = tem/cnt
    D = matrix(data=0,nrow=1,ncol=tnc)
    Val = matrix(data=0,nrow=1,ncol=tnc)
    for(k in 1:tnc)
    {
      if(C[k]<0)
      {
        ab = abs(C[k])
        if(ab>=L30)
        {
          dis = abs(L11-ab)
          val = -1
        }
        else
        {
          dis = abs(ab-L21)
          val = 0
        }
        D[k]= dis
        Val[k]=val
      }
      else
      {
        ab = C[k]
        if(ab>=L30)
        {
          dis = abs(L11-ab)
          val = 1
        }
        else
        {
          dis = abs(ab-L21)
          val = 0
        }
        D[k]= dis
        Val[k]=val
      }
    }
    x = which.min(D)
    y = Val[x]
    pos = Cal[x]
    Ref1[pos]=y
    Ref2[pos]=1
    cnt = cnt+1
    Loc[cnt]=pos
    for(m in x:tnc)
    {
      if(m==tnc)
      {
        Cal[m] = 0
      }
      else
      {
        Cal[m]= Cal[m+1]
      }
    }
  }
  return(Ref1)
}